/******************************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is strictly *
* prohibited. Copyright (c)  1993  by Altera Corp. All Rights Reserved.       *
*******************************************************************************/
/*

LIBRARY        : alteralib; Rev 1.0; February 93
FUNCTION       : 4-BIT BINARY COUNTER
TRUTHTABLE     : 
          COUNT SEQUENCE
         -------------------   --------------------------
         COUNT  QD QC QB QA    R_0_1   R_0_2    QD QC QB QA
         -------------------   --------------------------
           0    L  L  L  L      H     H         L  L  L  L
           1    L  L  L  H      X     L           COUNT
           2    L  L  H  L      L     X           COUNT
           3    L  L  H  H     --------------------------
           4    L  H  L  L    
           5    L  H  L  H    
           6    L  H  H  L    
           7    L  H  H  H    
           8    H  L  L  L    
           9    H  L  L  H
          10    H  L  H  L
          11    H  L  H  H
          12    H  H  L  L
          13    H  H  L  H
          14    H  H  H  L
          15    H  H  H  H
         ------------------- 
        NOTE : OUTPUT QA IS CONNECTED TO INPUT CKB.
                          
REFERENCE      : Altera MAX+Plus II online help, component description
DESIGNER       : AMI VIDER
DATE GENERATED : February 1993
DATE MODIFIED  : August 1993

VERITOOL COMPATIBILITY : Verilog x.x, Veritime y.y

*/
`celldefine

`timescale  1ns /  100ps
module a293 (qc, qb, qd, qa, cka, ckb, r01, r02);
	parameter size =1;
	parameter cds_action = "ignore";
	input
		cka,
		ckb,
		r01,
		r02;
	output
		qc,
		qb,
		qd,
		qa;
    reg
        NOTIFY_REG;
    nand
	  (en, r01, r02);
    nand  
	M293N_inst_N1 (m293n_inst_clrb, r01, r02);
    not  
	  (m293n_inst_cka_, cka);
    not  
	  (m293n_inst_ckb_, ckb);
    not
	  (m293n_inst_qbint_, m293n_inst_qbint);
    not
	  (m293n_inst_qcint_, m293n_inst_qcint);
    buf
	  (qa, m293n_inst_qaint);
    buf
	  (qb, m293n_inst_qbint);
    buf
	  (qc, m293n_inst_qcint);
    buf
	  (qd, m293n_inst_qdint);
    U_FT_P_RB_NO
	M293N_inst_Inst1_inst1 (m293n_inst_qaint, m293n_inst_cka_, m293n_inst_clrb, NOTIFY_REG);
    U_FT_P_RB_NO
	M293N_inst_Inst2_inst1 (m293n_inst_qbint, m293n_inst_ckb_, m293n_inst_clrb, NOTIFY_REG);
    U_FT_P_RB_NO
	M293N_inst_Inst3_inst1 (m293n_inst_qcint, m293n_inst_qbint_, m293n_inst_clrb, NOTIFY_REG);
    U_FT_P_RB_NO
	M293N_inst_Inst4_inst1 (m293n_inst_qdint, m293n_inst_qcint_, m293n_inst_clrb, NOTIFY_REG);

    specify

	// Synthesis parameters

`ifdef SYNTH
	specparam Area = 1;
`endif



    endspecify

endmodule
`endcelldefine
